<?xml version="1.0" encoding="UTF-8"?>
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" abstract="true" id="MFMT_MT902100NL">
    <title>Act Category Reference</title>
    <rule context="$element">
        <!--assert role="error" test="not(@classCode) or @classCode='CATEGORY'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/ActClass.htm#CATEGORY"
            >MFMT_MT902001NL: <value-of select="local-name(.)"/>/@classCode moet 'CATEGORY' zijn</assert>
            <assert role="error" test="not(@moodCode) or @moodCode='EVN'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/ActMood.htm#EVN"
            >MFMT_MT902001NL: <value-of select="local-name(.)"/>/@moodCode moet 'EVN' zijn</assert-->

        <let name="codeValue" value="../../hl7:code/@code"/>
        <let name="codeSystem" value="../../hl7:code/@codeSystem"/>

        <let name="classCode" value="@classCode"/>
        <let name="classCodeRoot" value="'2.16.840.1.113883.5.6'"/>
        <let name="expectClassCode" value="document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]/hl7:reference[@root=$classCodeRoot]/@extension"/>

        <!-- Niet alle ActRegistryCodes hebben reeds een reference element -->
        <assert role="error" test="@classCode">MFMT_MT902100NL: @classCode is verplicht</assert>
        <assert role="error" test="$classCode='CATEGORY' or 
            not(document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]/hl7:reference) or
            $classCode=$expectClassCode">MFMT_MT902100NL: Gegevenssoort '<value-of select="$codeValue"/>' komt niet overeen met de classCode van de ActReference '<value-of select="@classCode"/>'. Verwacht werd '<value-of select="$expectClassCode"/>'.</assert>

        <let name="moodCode" value="@moodCode"/>
        <let name="moodCodeRoot" value="'2.16.840.1.113883.5.1001'"/>
        <let name="expectMoodCode" value="document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]/hl7:reference[@root=$moodCodeRoot]/@extension"/>

        <assert role="error" test="not($classCode='CATEGORY') or $moodCode='EVN'">MFMT_MT902100NL: @moodCode moet 'EVN' zijn voor categorale aanmeldingen</assert>

        <assert role="error" test="$classCode='CATEGORY' or 
            not(document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]/hl7:reference) or
            $moodCode=$expectMoodCode">MFMT_MT902100NL: Gegevenssoort '<value-of select="$codeValue"/>' komt niet overeen met de moodCode van de ActReference '<value-of select="@moodCode"/>'. Verwacht werd '<value-of select="$expectMoodCode"/>'.</assert>

        <assert test="hl7:recordTarget">MFMT_MT902100NL: recordTarget moet aanwezig zijn</assert>
        <assert test="hl7:custodian">MFMT_MT902100NL: custodian moet aanwezig zijn</assert>
    </rule>

    <title>recordTarget</title>
    <rule context="$element/hl7:recordTarget/hl7:patient">
        <assert role="warning" test="count(hl7:id)=1">MFMT_MT902100NL: alleen het burgerservicenummer van de patiënt wordt opgeslagen</assert>
    </rule>

    <rule context="$element/hl7:recordTarget/hl7:patient/hl7:id">
        <extends rule="II"/>
        <assert role="error" test="@root='2.16.840.1.113883.2.4.6.3'">MFMT_MT902100NL: recordTarget/patient/id moet een burgerservicenummer zijn</assert>
    </rule>

    <title>custodian</title>
    <rule context="$element/hl7:custodian">
        <assert role="error" test="not(@typeCode) or @typeCode='CST'">MFMT_MT902100NL: custodian/@classCode moet indien aanwezig 'CST' zijn</assert>
        <assert role="error" test="hl7:assignedOrganization/hl7:id">MFMT_MT902100NL: custodian/assignedOrganization/id moet aanwezig zijn</assert>
        <assert role="error" test="hl7:assignedOrganization/hl7:telecom">MFMT_MT902100NL: custodian/assignedOrganization/telecom moet aanwezig zijn</assert>
    </rule>

    <rule context="$element/hl7:custodian/hl7:assignedOrganization/hl7:id">
        <extends rule="II"/>
        <assert role="error" test="@root='2.16.528.1.1007.3.3'">MFMT_MT902100NL: custodian/assignedOrganization/id moet een URA-nummer zijn</assert>
    </rule>

    <rule context="$element/hl7:custodian/hl7:assignedOrganization/hl7:telecom">
        <extends rule="TEL"/>
        <assert role="error" test="starts-with(@value,'x-hl7-applicatie:')">MFMT_MT902100NL: custodian/assignedOrganization/telecom moet een applicatie-id zijn</assert>
    </rule>
</pattern>
